/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.phys.Vec3;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.gui.widgets.ParentedButton;
import org.figuramc.figura.lua.api.sound.LuaSound;
import org.figuramc.figura.utils.ui.UIHelper;

public class PianoWidget
extends AbstractContainerElement {
    private static final int TOTAL_KEYS = 29;
    private static final String[] NOTES = new String[]{"F", "G", "A", "B", "C", "D", "E"};
    private final List<Key> keys = new ArrayList<Key>();
    private final Supplier<LuaSound> soundSupplier;
    private Key hovered;
    public boolean pressed;

    public PianoWidget(int x, int y, int width, int height, Supplier<LuaSound> soundSupplier) {
        super(x, y, width, height);
        this.soundSupplier = soundSupplier;
        double keyWidth = (double)(width - 2) / Math.ceil(14.5);
        float j = 0.0f;
        ArrayList<Key> sharpKeys = new ArrayList<Key>();
        int i = 1;
        int note = 0;
        int count = 0;
        while (i <= 29) {
            if (i % 2 != 1 || i % 7 != 0 && (i + 1) % 7 != 0) {
                boolean isSharp = i % 2 == 1;
                int keyX = x + 1 + (int)(keyWidth * (double)j);
                if (!isSharp) {
                    note = (note + 1) % NOTES.length;
                }
                Key key = new Key(keyX, y + 1, (int)Math.round(keyWidth), isSharp ? height / 2 : height - 2, NOTES[note] + (isSharp ? "#" : ""), (float)Math.pow(2.0, (float)(count - 12) / 12.0f), isSharp, this);
                ++count;
                if (!isSharp) {
                    this.children.add(key);
                } else {
                    sharpKeys.add(key);
                }
                this.keys.add(key);
            }
            ++i;
            j += 0.5f;
        }
        this.children.addAll(sharpKeys);
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        this.setHovered(this.isMouseOver(mouseX, mouseY));
        UIHelper.blitSliced(gui, this.getX(), this.getY(), this.getWidth(), this.getHeight(), UIHelper.OUTLINE_FILL);
        Key lastHovered = this.hovered;
        for (Key key : this.keys) {
            key.setHovered(key.isMouseOver(mouseX, mouseY));
        }
        super.render(gui, mouseX, mouseY, delta);
        if (this.pressed && this.hovered != lastHovered && this.hovered != null) {
            this.hovered.run();
        }
    }

    private static class Key
    extends ParentedButton {
        private final PianoWidget parent;
        private final float pitch;
        private final boolean isSharp;

        public Key(int x, int y, int width, int height, String key, float pitch, boolean isSharp, PianoWidget parent) {
            super(x, y, width, height, (Component)Component.literal((String)key), parent, button -> {});
            this.parent = parent;
            this.pitch = pitch;
            this.isSharp = isSharp;
        }

        public void playDownSound(SoundManager soundManager) {
            LuaSound sound = this.parent.soundSupplier.get();
            if (sound != null) {
                Vec3 vec = Minecraft.getInstance().player == null ? new Vec3(0.0, 0.0, 0.0) : Minecraft.getInstance().player.position();
                sound.pos(vec.x, vec.y, vec.z).pitch(this.pitch).play();
            } else {
                soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.NOTE_BLOCK_HARP.value()), (float)this.pitch, (float)1.0f));
            }
        }

        @Override
        public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            if (!this.isVisible()) {
                return;
            }
            UIHelper.fillRounded(gui, this.getX(), this.getY(), this.getWidth(), this.getHeight(), (this.isSharp ? 0 : 0xFFFFFF) + -16777216);
            UIHelper.blitSliced(gui, this.getX(), this.getY(), this.getWidth(), this.getHeight(), UIHelper.OUTLINE);
            if (this.isHovered()) {
                UIHelper.fillRounded(gui, this.getX(), this.getY(), this.getWidth(), this.getHeight(), FiguraMod.getAccentColor().getColor().getValue() + -1610612736);
            }
            Font font = Minecraft.getInstance().font;
            Component message = this.getMessage();
            int x = this.getX() + this.getWidth() / 2 - font.width((FormattedText)message) / 2;
            int n = this.getY() + this.getHeight() / 2;
            Objects.requireNonNull(font);
            int y = n - 9 / 2;
            if (!this.isSharp) {
                y += this.getHeight() / 4;
            }
            gui.drawString(font, this.getMessage(), x, y, this.isSharp ? 0xFFFFFF : 0, false);
        }

        @Override
        public boolean isMouseOver(double mouseX, double mouseY) {
            boolean over = super.isMouseOver(mouseX, mouseY);
            if (this.parent.hovered == this) {
                this.parent.hovered = over ? this : null;
                return over;
            }
            if (!over) {
                return false;
            }
            if (this.parent.hovered == null) {
                this.parent.hovered = this;
                return true;
            }
            if (this.parent.hovered.isSharp) {
                return false;
            }
            if (this.isSharp) {
                this.parent.hovered.setHovered(false);
                this.parent.hovered = this;
                return true;
            }
            return false;
        }
    }
}

